### 控制系统故障的网络保护

在PLC重启、断开或故障时，EtherCAT电缆冗余功能无法保护控制系统。

主站冗余方案解决了上述问题并允许在同步环境中保持运行。

![](https://resource.helplook.net/docker_production/3648ne/article/YHao1HNg/68d1332b4f24e.png)

**优点和主要特点**

- **支持任意网络拓扑结构**  
    主站冗余支持任意拓扑结构的网络，例如环形、星形和菊花链。

- **经济高效的解决方案**   
    为了系统稳定运行，无需使用昂贵的设备。  
    对系统故障的快速响应  
    冗余主机可以立即接管控制，无需任何专用控制装置、额外的信号线或手动控制。

- **配置热插拔**   
    对于以不停机模式运行的系统（限制过程中断），无缝更换总线配置中的设备，而不会导致其他设备发生故障。

---

### 软件解决方案细节

**数据感知**

Master 1（Primary Master,主机设备）完全控制EtherCAT总线（生成 EtherCAT 帧、检查从设备状态、更新过程映射等）。处于辅助模式的Master 2（Secondary Master，备机设备）会感知总线上的帧以获取实际数据。因此，如果Master 1不可用，Master 2会掌握所有必要的总线信息，并随时准备切换到主控模式，接管总线控制权，且不会丢失数据。

![](https://resource.helplook.net/docker_production/3648ne/article/YHao1HNg/68d1349377516.png)

**数据同步**

后台的Master 2从总线获取实际数据：过程数据、从机状态、端口状态和统计数据，并像Master 1一样创建实际配置。

![](https://resource.helplook.net/docker_production/3648ne/article/YHao1HNg/68d134aaa1687.png)

**主循环同步**

Master 1和Master 2的循环时间力求同步。

为了保持这种同步，每个周期， Master 2都会调整其与Master 1的循环时间。

![](https://resource.helplook.net/docker_production/3648ne/article/YHao1HNg/68d134c106ff8.png)

**快速切换**

Master 2与Master 1同步后，它会循环检查总线上是否发生活动，如果没有接收到帧，则Master 2切换到主模式并将帧发送到总线。

![](https://resource.helplook.net/docker_production/3648ne/article/YHao1HNg/68d1354a3fae7.png)

**优点：**

立即从辅助模式切换到主模式，无延迟

无需重新配置总线

数据和从属状态同步